define(['angular', 'app'], function (angular, app) {
	'use strict';
	app.service('RequestsService', function ($http, $q, localResourceDirectoryService) {

		var RequestsService = {};

		var requestUrl = localResourceDirectoryService['request-eligibility-criteria'];
		var saveOptions = {};

		RequestsService.fetch = function(locationId) {
			return $http.get(requestUrl.replace('{site-code}', locationId));
		};

		RequestsService.save = function(data, locationId) {
			// update parameters for saving
			if(!_.isEmpty(data.link)) {
				saveOptions = {
					url: data.link[0].href,
					method: 'put'
				};
			} else {
				saveOptions = {
					url: requestUrl.replace('{site-code}', locationId),
					method: 'post'
				};
			}

			return $http[saveOptions.method](saveOptions.url, data);
		};

		return RequestsService;
	});
});